/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.model.auth;

import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.topicus.cobra.restcontract.model.auth.AuthenticationParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RemoteAuthentication
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String authenticateUrl;
    @XmlElement(name="parameter")
    @XmlElementWrapper
    @Valid
    private List<AuthenticationParameter> parameters = new ArrayList<AuthenticationParameter>();
    @XmlElement
    private String provider;
    @XmlElement
    private String callback;

    public String getAuthenticateUrl() {
        return this.authenticateUrl;
    }

    public void setAuthenticateUrl(String authenticateUrl) {
        this.authenticateUrl = authenticateUrl;
    }

    public String getParameter(String name) {
        for (AuthenticationParameter curParam : this.getParameters()) {
            if (!curParam.getKey().equals(name)) continue;
            return curParam.getValue();
        }
        return null;
    }

    public List<AuthenticationParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<AuthenticationParameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.getParameters().add(new AuthenticationParameter(key, value));
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        for (AuthenticationParameter curParam : this.getParameters()) {
            ret.put(curParam.getKey(), new String[]{curParam.getValue()});
        }
        return ret;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }
}

