/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.model.auth;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import nl.topicus.cobra.restcontract.model.auth.PermittedOperation;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.cobra.restcontract.security.PermissionCategoryInstance;
import nl.topicus.cobra.restcontract.security.RestPermission;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private String full;
    @XmlAttribute
    private String type;
    @XmlList
    @XmlAttribute
    private Set<PermittedOperation> operations = EnumSet.noneOf(PermittedOperation.class);
    @XmlList
    @XmlAttribute
    private List<String> instances = new ArrayList<String>();

    public Permission() {
    }

    public Permission(RestPermission permission) {
        this.full = permission.toString();
        this.type = permission.getEntityName();
        this.operations = PermittedOperation.toPermittedOperation(permission.getOperations());
        for (PermissionCategoryInstance instance : permission.getInstances()) {
            if (instance == null) continue;
            this.instances.add(instance.toString());
        }
    }

    public String getFull() {
        return this.full;
    }

    public void setFull(String full) {
        this.full = full;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<PermittedOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(Set<PermittedOperation> operations) {
        this.operations = operations;
    }

    public List<String> getInstances() {
        return this.instances;
    }

    public void setInstances(List<String> instances) {
        this.instances = instances;
    }

    public boolean merge(Permission permission) {
        if (this.getType().equals(permission.getType()) && this.getInstances().equals(permission.getInstances())) {
            this.operations.addAll(permission.getOperations());
            RestPermission thisPermission = new RestPermission(this.getFull());
            this.setFull(new RestPermission(thisPermission.getEntity(), Operation.toOperation(this.getOperations()), Collections.unmodifiableList(new ArrayList<PermissionCategoryInstance>(thisPermission.getInstances()))).toString());
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getFull();
    }
}

