/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.topicus.cobra.commons.interfaces.Omschrijfbaar;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.ILinkable;
import nl.topicus.cobra.restcontract.model.Link;
import nl.topicus.cobra.restcontract.model.auth.Permission;
import nl.topicus.cobra.restcontract.model.auth.PermittedOperation;
import nl.topicus.cobra.restcontract.xmladapter.AdditionalObjectMapAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="$type")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Linkable
implements Serializable,
Omschrijfbaar,
ILinkable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="link")
    private List<Link> links = new ArrayList<Link>();
    @XmlElement(name="permission")
    private List<Permission> permissions = new ArrayList<Permission>();
    @XmlElement(name="additionalObjects")
    @XmlJavaTypeAdapter(value=AdditionalObjectMapAdapter.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="$type")
    @Valid
    private Map<String, Object> additionalObjects = new HashMap<String, Object>();

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setLink(Link link) {
        Link oldLink = this.getLink(link.getRel());
        if (oldLink != null) {
            this.getLinks().remove(oldLink);
        }
        this.links.add(link);
    }

    @Override
    public Link self() {
        return this.getLink("self");
    }

    public Link identiteit() {
        return this.getLink("identiteit");
    }

    @Override
    public Link koppeling() {
        return this.getLink("koppeling");
    }

    @Override
    public Link getLink(String rel) {
        for (Link curLink : this.getLinks()) {
            if (!curLink.getRel().equals(rel)) continue;
            return curLink;
        }
        return null;
    }

    @Override
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(Permission permission) {
        for (Permission curPermission : this.permissions) {
            if (!curPermission.merge(permission)) continue;
            return;
        }
        this.permissions.add(permission);
    }

    public boolean isAllowed(PermittedOperation operation) {
        for (Permission permission : this.getPermissions()) {
            if (!permission.getOperations().contains((Object)operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toOmschrijving() {
        return null;
    }

    public int hashCode() {
        Link self = this.self();
        if (self != null) {
            return this.self().hashCode();
        }
        Link koppeling = this.koppeling();
        if (koppeling != null) {
            return koppeling.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Linkable) {
            Link thisSelf = this.self();
            Link thisKoppeling = this.koppeling();
            Link otherSelf = ((Linkable)obj).self();
            Link otherKoppeling = ((Linkable)obj).koppeling();
            if (thisSelf == null && otherSelf == null && thisKoppeling != null && otherKoppeling != null) {
                return thisKoppeling.equals(otherKoppeling);
            }
            if (thisSelf == null || otherSelf == null) {
                return super.equals(obj);
            }
            return thisSelf.equals(otherSelf) && (thisKoppeling == null || otherKoppeling == null || thisKoppeling.equals(otherKoppeling));
        }
        return false;
    }

    public String toString() {
        String omschrijving = this.toOmschrijving();
        Link link = this.self();
        if (link == null) {
            link = this.getLink("koppeling");
        }
        return this.getClass().getSimpleName() + (omschrijving == null ? "" : "(" + this.toOmschrijving() + ")") + "@" + link;
    }

    public Map<String, Object> getAdditionalObjects() {
        return this.additionalObjects;
    }

    public void setAdditionalObjects(Map<String, Object> additionalObjects) {
        this.additionalObjects = additionalObjects;
    }

    public <T> T getAdditionalObjects(AdditionalObjectKey<T> key) {
        return (T)this.additionalObjects.get(key.getName());
    }
}

