/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Link
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SELF = "self";
    public static final String IDENTITEIT = "identiteit";
    public static final String KOPPELING = "koppeling";
    @XmlAttribute
    private Long id;
    @XmlAttribute
    private String rel;
    @XmlAttribute
    private String type;
    @XmlAttribute
    private URI href;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public URI getHref() {
        return this.href;
    }

    public void setHref(URI href) {
        this.href = href;
    }

    public static Link self(long id, URI href) {
        return Link.build(id, SELF, href);
    }

    public static Link build(long id, URI href) {
        return Link.build(id, null, href);
    }

    public static Link build(long id, String rel, URI href) {
        Link ret = new Link();
        ret.setId(id);
        ret.setRel(rel);
        ret.setHref(href);
        return ret;
    }

    public Link as(String rel) {
        Link ret = new Link();
        ret.setId(this.getId());
        ret.setHref(this.getHref());
        ret.setRel(rel);
        return ret;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.id, this.rel, this.href});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link other = (Link)obj;
            return other.getId().equals(this.getId()) && other.getRel().equals(this.getRel()) && Link.equal(other.getHref(), this.getHref());
        }
        return false;
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public String toString() {
        return "<link rel=\"" + this.rel + "\" id=\"" + this.id + "\" href=\"" + this.href + "\" />";
    }

    public static Link parseString(String input) {
        Pattern segmentpattern = Pattern.compile("rel=\"\\S+\"|id=\"\\S+\"|href=\"\\S+\"", 2);
        Matcher segmentmatcher = segmentpattern.matcher(input);
        long id = -1L;
        String rel = null;
        URI href = null;
        while (segmentmatcher.find()) {
            String segment = segmentmatcher.group();
            if (segment.startsWith("id")) {
                id = Long.parseLong(segment.replace("id=\"", "").replace("\"", ""));
                continue;
            }
            if (segment.startsWith("rel")) {
                rel = segment.replace("rel=\"", "").replace("\"", "");
                continue;
            }
            if (!segment.startsWith("href")) continue;
            href = URI.create(segment.replace("href=\"", "").replace("\"", ""));
        }
        if (rel == null || id < 0L || href == null) {
            return null;
        }
        return Link.build(id, rel, href);
    }
}

