/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.topicus.cobra.restcontract.http.Ranges;
import nl.topicus.cobra.restcontract.http.RequestRange;

public class ResponseRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("items (\\d+)-(\\d+)/(\\d+)");
    public static final String STR_KEY = "Content-Range";
    private long start;
    private long end;
    private long totalSize;

    public ResponseRange(String value) {
        Matcher matcher = RANGE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(value);
        }
        this.start = Long.parseLong(matcher.group(1));
        this.end = Long.parseLong(matcher.group(2));
        this.totalSize = Long.parseLong(matcher.group(3));
        if (this.start < 0L || this.start > this.end && (this.start != this.totalSize || this.end != this.start - 1L)) {
            throw new IllegalArgumentException(value);
        }
    }

    public ResponseRange(RequestRange range, long actualSize, long totalSize) {
        this.start = range.getStart();
        this.end = Ranges.inRange(range.getStart() + actualSize - 1L, 0, totalSize);
        this.totalSize = totalSize;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getSize() {
        return this.end - this.start + 1L;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public String toString() {
        return "items " + this.getStart() + "-" + this.getEnd() + "/" + this.getTotalSize();
    }
}

