/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("items=(\\d+)-(\\d+)");
    public static final String STR_KEY = "Range";
    private long start;
    private long end;

    public RequestRange(String value) {
        Matcher matcher = RANGE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(value);
        }
        this.start = Long.parseLong(matcher.group(1));
        this.end = Long.parseLong(matcher.group(2));
        if (this.start < 0L || this.start > this.end) {
            throw new IllegalArgumentException(value);
        }
    }

    public RequestRange(long start, long count) {
        this.start = start;
        this.end = start + Math.max(count, 1L) - 1L;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getSize() {
        return this.end - this.start + 1L;
    }

    public int getStartInt() {
        if (this.getStart() > Integer.MAX_VALUE) {
            throw new IllegalStateException("Start out of range: " + this.getStart());
        }
        return (int)this.getStart();
    }

    public int getSizeInt() {
        if (this.getSize() > Integer.MAX_VALUE) {
            throw new IllegalStateException("Size out of range: " + this.getSize());
        }
        return (int)this.getSize();
    }

    public String toString() {
        return "items=" + this.getStart() + "-" + this.getEnd();
    }
}

