/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.exception;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.topicus.cobra.restcontract.model.ErrorReport;

public class RestWebApplicationException
extends WebApplicationException {
    private static final long serialVersionUID = 1L;
    private String applicationError;
    private Map<String, String> applicationErrorParameters;
    private List<String> errorDetails;

    public RestWebApplicationException(Response.Status status, Enum<?> applicationError) {
        super(status);
        this.applicationError = applicationError.name();
    }

    public RestWebApplicationException(ErrorReport report) {
        super(report.getCode());
        this.applicationError = report.getApplicationError();
        this.applicationErrorParameters = report.getApplicationErrorParameters();
        this.errorDetails = report.getErrorDetails();
    }

    public List<String> getErrorDetails() {
        return this.errorDetails;
    }

    public RestWebApplicationException setErrorDetails(List<String> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public String getApplicationError() {
        return this.applicationError;
    }

    public RestWebApplicationException setApplicationError(String applicationError) {
        this.applicationError = applicationError;
        return this;
    }

    public Map<String, String> getApplicationErrorParameters() {
        return this.applicationErrorParameters;
    }

    public RestWebApplicationException setApplicationErrorParameters(Map<String, String> applicationErrorParameters) {
        this.applicationErrorParameters = applicationErrorParameters;
        return this;
    }

    public RestWebApplicationException withErrorParameter(String name, String value) {
        if (this.applicationErrorParameters == null) {
            this.applicationErrorParameters = new LinkedHashMap<String, String>();
        }
        this.applicationErrorParameters.put(name, value);
        return this;
    }
}

