/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.marshalling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import nl.topicus.cobra.spi.ContractFilterService;
import nl.topicus.cobra.spi.ContractService;
import nl.topicus.cobra.spi.ContractSortService;

public final class ServiceContractResolver {
    private static final List<ContractService> permissionServices = ServiceContractResolver.scanContractServices(Thread.currentThread().getContextClassLoader());

    private ServiceContractResolver() {
    }

    public static List<ContractService> scanContractServices(ClassLoader classLoader) {
        Iterator<ContractSortService> curService;
        ContractFilterService filterService = ContractFilterService.AlwaysTrueContractFilterService.INSTANCE;
        Iterator<ContractFilterService> iterator = ServiceLoader.load(ContractFilterService.class, classLoader).iterator();
        if (iterator.hasNext()) {
            curService = iterator.next();
            filterService = curService;
        }
        ContractSortService sortService = ContractSortService.VersionContractSortService.INSTANCE;
        curService = ServiceLoader.load(ContractSortService.class, classLoader).iterator();
        if (curService.hasNext()) {
            ContractSortService curService2 = (ContractSortService)curService.next();
            sortService = curService2;
        }
        ArrayList<ContractService> services = new ArrayList<ContractService>();
        for (ContractService curService3 : ServiceLoader.load(ContractService.class, classLoader)) {
            if (!filterService.test(curService3)) continue;
            services.add(curService3);
        }
        Collections.sort(services, sortService);
        return services;
    }

    public static List<ContractService> getContractServices() {
        return Collections.unmodifiableList(permissionServices);
    }

    public static ContractService resolveContractService(Class<?> cls) {
        for (ContractService curContract : permissionServices) {
            if (!curContract.containsType(cls)) continue;
            return curContract;
        }
        return null;
    }

    public static String resolveName(Class<?> cls) {
        for (ContractService curContract : permissionServices) {
            String resolvedName = curContract.resolveName(cls);
            if (resolvedName == null) continue;
            return resolvedName;
        }
        return null;
    }

    public static Class<?> resolveModelClass(String name) {
        for (ContractService curContract : permissionServices) {
            Class<?> resolvedType = curContract.resolveModelClass(name);
            if (resolvedType == null) continue;
            return resolvedType;
        }
        return null;
    }

    public static boolean implies(String base, String check) {
        for (ContractService curContract : permissionServices) {
            if (!curContract.implies(base, check)) continue;
            return true;
        }
        return false;
    }

    public static boolean versionEqualsContractServiceVersion(int versionNumber) {
        for (ContractService curContract : permissionServices) {
            if (curContract.getMediaType() == null) continue;
            return versionNumber == curContract.getVersion();
        }
        return false;
    }

    public static Optional<String> getDefaultMediaType() {
        for (ContractService curContract : permissionServices) {
            if (curContract.getMediaType() == null) continue;
            return Optional.of(curContract.getMediaType());
        }
        return Optional.empty();
    }

    public static <L> Optional<String> getDefaultMediaType(Class<L> clazz) {
        for (ContractService curContract : permissionServices) {
            if (curContract.getMediaType() == null || !curContract.containsType(clazz)) continue;
            return Optional.of(curContract.getMediaType());
        }
        return Optional.empty();
    }
}

