/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.marshalling;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import java.util.Collection;
import nl.topicus.cobra.marshalling.CobraPropertyTypeDeserializer;
import nl.topicus.cobra.marshalling.CobraPropertyTypeSerializer;
import nl.topicus.cobra.marshalling.RestContractTypeIdResolver;
import nl.topicus.cobra.spi.ContractService;

public class RestContractTypeIdResolverBuilder
extends StdTypeResolverBuilder {
    private ContractService contract;

    public RestContractTypeIdResolverBuilder(ContractService contract) {
        this.contract = contract;
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        if (JsonTypeInfo.As.PROPERTY.equals((Object)this._includeAs)) {
            TypeIdResolver idRes = this.idResolver(config, baseType, this.verifyBaseTypeValidity(config, baseType), subtypes, true, false);
            return new CobraPropertyTypeSerializer(idRes, null, this._typeProperty);
        }
        return super.buildTypeSerializer(config, baseType, subtypes);
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (this._idType == JsonTypeInfo.Id.NONE || baseType.isPrimitive()) {
            return null;
        }
        if (this._includeAs.equals((Object)JsonTypeInfo.As.PROPERTY)) {
            TypeIdResolver idRes = this.idResolver(config, baseType, this.verifyBaseTypeValidity(config, baseType), subtypes, false, true);
            return new CobraPropertyTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, null, this._includeAs, this._strictTypeIdHandling(config, baseType));
        }
        return super.buildTypeDeserializer(config, baseType, subtypes);
    }

    @Override
    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        return new RestContractTypeIdResolver(baseType, config.getTypeFactory(), this.contract, subtypeValidator);
    }
}

