/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.marshalling;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import nl.topicus.cobra.marshalling.ServiceContractResolver;
import nl.topicus.cobra.spi.ContractService;

public class RestContractTypeIdResolver
extends ClassNameIdResolver {
    private ContractService contract;

    public RestContractTypeIdResolver(JavaType baseType, TypeFactory typeFactory, ContractService contract, PolymorphicTypeValidator pvt) {
        super(baseType, typeFactory, pvt);
        this.contract = contract;
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    @Override
    public String idFromValue(Object value) {
        return this.shortIdFrom(value, value.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> type) {
        return this.shortIdFrom(value, type, this._typeFactory);
    }

    @Override
    protected JavaType _typeFromId(String id, DatabindContext ctxt) throws IOException {
        Class<?> resolvedType = null;
        if (this.contract != null) {
            resolvedType = this.contract.resolveModelClass(id);
            if (resolvedType == null && this.contract.getBase() != null) {
                resolvedType = this.contract.getBase().resolveModelClass(id);
            }
        } else {
            resolvedType = ServiceContractResolver.resolveModelClass(id);
        }
        return resolvedType == null ? super._typeFromId(id, ctxt) : super._typeFromId(resolvedType.getName(), ctxt);
    }

    protected String shortIdFrom(Object value, Class<?> cls, TypeFactory typeFactory) {
        String shortId = null;
        if (this.contract != null) {
            shortId = this.contract.resolveName(cls);
            if (shortId == null && this.contract.getBase() != null) {
                shortId = this.contract.getBase().resolveName(cls);
            }
        } else {
            shortId = ServiceContractResolver.resolveName(cls);
        }
        return shortId == null ? this._idFrom(value, cls, typeFactory) : shortId;
    }
}

