/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.marshalling;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.joda.deser.LocalDateDeserializer;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CobraLocalDateDeserializer
extends LocalDateDeserializer {
    private static final long serialVersionUID = 1L;
    static final DateTimeFormatter parser = ISODateTimeFormat.localDateParser();

    @Override
    public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_ARRAY: {
                if (!jp.isExpectedStartArrayToken()) break;
                jp.nextToken();
                int year = jp.getIntValue();
                jp.nextToken();
                int month = jp.getIntValue();
                jp.nextToken();
                int day = jp.getIntValue();
                jp.nextToken();
                if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    jp.nextToken();
                    jp.nextToken();
                    jp.nextToken();
                    if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                        jp.nextToken();
                    }
                    if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                        throw ctxt.wrongTokenException(jp, TypeFactory.rawClass(LocalDate.class), JsonToken.END_ARRAY, "after LocalDateTime ints");
                    }
                }
                return new LocalDate(year, month, day);
            }
            case VALUE_NUMBER_INT: {
                return new LocalDate(jp.getLongValue());
            }
            case VALUE_STRING: {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                if (str.toLowerCase().contains("t")) {
                    return DateTime.parse(str).toLocalDate();
                }
                return parser.parseLocalDate(str);
            }
        }
        throw ctxt.wrongTokenException(jp, TypeFactory.rawClass(LocalDate.class), JsonToken.START_ARRAY, "expected JSON Array, Number or String");
    }
}

