/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.marshalling;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.annotation.Annotation;
import nl.topicus.cobra.marshalling.RestContractTypeIdResolverBuilder;

public class CobraAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private boolean hasJakarta = false;

    public CobraAnnotationIntrospector() {
        try {
            CobraAnnotationIntrospector.class.getClassLoader().loadClass("jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            this.hasJakarta = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected <A extends Annotation> A _findAnnotation(Annotated annotated, Class<A> annoClass) {
        if (annotated instanceof AnnotatedClass && (annoClass.equals(JsonAutoDetect.class) || annoClass.equals(JsonInclude.class))) {
            return AnnotationHolder.class.getAnnotation(annoClass);
        }
        return super._findAnnotation(annotated, annoClass);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType containerType) {
        for (Annotation annot : am.getAllAnnotations().annotations()) {
            if (!annot.annotationType().getSimpleName().equals("XmlJavaTypeAdapter")) continue;
            if (this.hasJakarta) {
                XmlJavaTypeAdapter adapter = (XmlJavaTypeAdapter)annot;
                if (!adapter.value().getName().endsWith(".xmladapter.AdditionalObjectMapAdapter")) continue;
                am.getAllAnnotations().addIfNotPresent(AnnotationHolder.class.getAnnotation(JsonTypeInfo.class));
                continue;
            }
            am.getAllAnnotations().addIfNotPresent(AnnotationHolder.class.getAnnotation(JsonTypeInfo.class));
        }
        if (am.hasAnnotation(JsonTypeInfo.class)) {
            am.getAllAnnotations().addIfNotPresent(AnnotationHolder.class.getAnnotation(JsonTypeResolver.class));
        }
        return super.findPropertyContentTypeResolver(config, am, containerType);
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        JsonTypeInfo typeInfo = ac.getAnnotation(JsonTypeInfo.class);
        if (typeInfo != null && JsonTypeInfo.Id.CUSTOM.equals((Object)typeInfo.use())) {
            ((AnnotationMap)ac.getAnnotations()).addIfNotPresent(AnnotationHolder.class.getAnnotation(JsonTypeResolver.class));
        }
        return super.findTypeResolver(config, ac, baseType);
    }

    @JsonTypeResolver(value=RestContractTypeIdResolverBuilder.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="$type")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class AnnotationHolder {
        private AnnotationHolder() {
        }
    }
}

