/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.utils.predicates;

import com.github.rvesse.airline.utils.predicates.AbstractLocaleSensitiveStringFinder;
import java.util.Locale;

public class PrefixMatcher
extends AbstractLocaleSensitiveStringFinder {
    private final String[] prefixes;
    private final boolean ignoreCase;

    public PrefixMatcher(boolean ignoreCase, Locale locale, String ... prefixes) {
        super(locale);
        this.ignoreCase = ignoreCase;
        this.prefixes = prefixes;
        if (ignoreCase) {
            for (int i = 0; i < this.prefixes.length; ++i) {
                this.prefixes[i] = this.prefixes[i].toLowerCase(locale);
            }
        }
    }

    @Override
    public boolean evaluate(String str) {
        for (String prefix : this.prefixes) {
            if (str.length() < prefix.length()) {
                return false;
            }
            String strPrefix = str.substring(0, prefix.length());
            if (this.ignoreCase) {
                strPrefix = strPrefix.toLowerCase(this.locale);
            }
            if (this.collator.compare(strPrefix, prefix) != 0) continue;
            return true;
        }
        return false;
    }
}

