/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types.numerics;

import com.github.rvesse.airline.parser.errors.ParseOptionConversionException;
import com.github.rvesse.airline.types.ConvertResult;
import com.github.rvesse.airline.types.numerics.DefaultNumericConverter;
import com.github.rvesse.airline.types.numerics.NumericCandidate;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ComplexNumericTypeConverter
extends DefaultNumericConverter {
    protected NumericCandidate parse(String value) {
        return new NumericCandidate(value);
    }

    protected BigDecimal getBigDecimal(NumericCandidate candidate) {
        return new BigDecimal(candidate.getValue());
    }

    protected BigInteger getBigInteger(NumericCandidate candidate) {
        return new BigInteger(candidate.getValue(), this.getRadix(candidate));
    }

    protected Long getLong(NumericCandidate candidate) {
        return Long.valueOf(candidate.getValue(), this.getRadix(candidate));
    }

    protected Double getDouble(NumericCandidate candidate) {
        return Double.valueOf(candidate.getValue());
    }

    protected Float getFloat(NumericCandidate candidate) {
        return Float.valueOf(candidate.getValue());
    }

    protected long getMultiplier(NumericCandidate candidate) {
        return 1L;
    }

    protected int getRadix(NumericCandidate candidate) {
        return 10;
    }

    @Override
    protected ConvertResult tryConvertBigDecimal(String name, String value) {
        NumericCandidate candidate = this.parse(value);
        BigDecimal base = this.getBigDecimal(candidate);
        long multiplier = this.getMultiplier(candidate);
        BigDecimal result = multiplier != 1L ? base.multiply(BigDecimal.valueOf(multiplier)) : base;
        return new ConvertResult(result);
    }

    @Override
    protected ConvertResult tryConvertDouble(String name, String value) {
        double result;
        NumericCandidate candidate = this.parse(value);
        double base = this.getDouble(candidate);
        long multiplier = this.getMultiplier(candidate);
        double d = result = multiplier != 1L ? base * (double)multiplier : base;
        if (result < Double.MIN_VALUE || result > Double.MAX_VALUE) {
            throw new ParseOptionConversionException(String.format("%s: Abbreviated numeric value \"%s\" evaluates to a value outside the range of the numeric type %s", name, value, Double.class.getSimpleName()), name, value, Double.class.getSimpleName());
        }
        return new ConvertResult(result);
    }

    @Override
    protected ConvertResult tryConvertFloat(String name, String value) {
        double result;
        NumericCandidate candidate = this.parse(value);
        float base = this.getFloat(candidate).floatValue();
        long multiplier = this.getMultiplier(candidate);
        double d = result = multiplier != 1L ? (double)(base * (float)multiplier) : (double)base;
        if (result < (double)1.4E-45f || result > 3.4028234663852886E38) {
            throw new ParseOptionConversionException(String.format("%s: Abbreviated numeric value \"%s\" evaluates to a value outside the range of the numeric type %s", name, value, Float.class.getSimpleName()), name, value, Float.class.getSimpleName());
        }
        return new ConvertResult(Float.valueOf((float)result));
    }

    @Override
    protected ConvertResult tryConvertBigInteger(String name, String value) {
        NumericCandidate candidate = this.parse(value);
        BigInteger base = this.getBigInteger(candidate);
        long multiplier = this.getMultiplier(candidate);
        BigInteger result = multiplier != 1L ? base.multiply(BigInteger.valueOf(multiplier)) : base;
        return new ConvertResult(result);
    }

    @Override
    protected ConvertResult tryConvertLong(String name, String value) {
        NumericCandidate candidate = this.parse(value);
        long base = this.getLong(candidate);
        long multiplier = this.getMultiplier(candidate);
        long result = multiplier != 1L ? base * multiplier : base;
        return new ConvertResult(result);
    }

    @Override
    protected ConvertResult tryConvertInteger(String name, String value) {
        long result;
        NumericCandidate candidate = this.parse(value);
        long base = this.getLong(candidate);
        long multiplier = this.getMultiplier(candidate);
        long l = result = multiplier != 1L ? base * multiplier : base;
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new ParseOptionConversionException(String.format("%s: Abbreviated numeric value \"%s\" evaluates to a value outside the range of the numeric type %s", name, value, Integer.class.getSimpleName()), name, value, Integer.class.getSimpleName());
        }
        return new ConvertResult((int)result);
    }

    @Override
    protected ConvertResult tryConvertShort(String name, String value) {
        long result;
        NumericCandidate candidate = this.parse(value);
        long base = this.getLong(candidate);
        long multiplier = this.getMultiplier(candidate);
        long l = result = multiplier != 1L ? base * multiplier : base;
        if (result < -32768L || result > 32767L) {
            throw new ParseOptionConversionException(String.format("%s: Abbreviated numeric value \"%s\" evaluates to a value outside the range of the numeric type %s", name, value, Short.class.getSimpleName()), name, value, Short.class.getSimpleName());
        }
        return new ConvertResult((short)result);
    }

    @Override
    protected ConvertResult tryConvertByte(String name, String value) {
        long result;
        NumericCandidate candidate = this.parse(value);
        long base = this.getLong(candidate);
        long multiplier = this.getMultiplier(candidate);
        long l = result = multiplier != 1L ? base * multiplier : base;
        if (result < -128L || result > 127L) {
            throw new ParseOptionConversionException(String.format("%s: Abbreviated numeric value \"%s\" evaluates to a value outside the range of the numeric type %s", name, value, Byte.class.getSimpleName()), name, value, Byte.class.getSimpleName());
        }
        return new ConvertResult((byte)result);
    }
}

