/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.options;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsMissingException;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRequiredUnlessRestriction
extends AbstractCommonRestriction {
    protected abstract <T> boolean unless(ParseState<T> var1, OptionMetadata var2);

    protected abstract <T> boolean unless(ParseState<T> var1, ArgumentsMetadata var2);

    protected abstract String unlessDescription();

    @Override
    public <T> void finalValidate(ParseState<T> state, OptionMetadata option) {
        if (CollectionUtils.find(state.getParsedOptions(), new ParsedOptionFinder(option)) == null && !this.unless(state, option)) {
            throw new ParseOptionMissingException(AirlineUtils.first(option.getOptions()), this.unlessDescription());
        }
    }

    @Override
    public <T> void finalValidate(ParseState<T> state, ArgumentsMetadata arguments) {
        if (state.getParsedArguments().isEmpty() && !this.unless(state, arguments)) {
            throw new ParseArgumentsMissingException("Required arguments '%s' are missing and %s", arguments.getTitle(), StringUtils.join(arguments.getTitle(), ", "), this.unlessDescription());
        }
    }
}

