/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.common.StartsWithRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.Locale;
import org.apache.commons.lang3.tuple.Pair;

public class NoOptionLikeValuesRestriction
extends StartsWithRestriction
implements GlobalRestriction {
    public NoOptionLikeValuesRestriction(String[] prefixes) {
        super(false, Locale.ROOT, prefixes);
    }

    @Override
    protected boolean isValid(String value) {
        return !super.isValid(value);
    }

    @Override
    protected <T> ParseRestrictionViolatedException violated(ParseState<T> state, OptionMetadata option, String value) {
        throw new ParseRestrictionViolatedException("Option %s value '%s' has value '%s' which appears to be an option, but was not recognized as such, was this option entered incorrectly?", AirlineUtils.first(option.getOptions()), AbstractCommonRestriction.getOptionTitle(state, option), value);
    }

    @Override
    protected <T> ParseRestrictionViolatedException violated(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        throw new ParseRestrictionViolatedException("Argument '%s' has value '%s' which appears to be an option, but was not recognized as such, was this option entered incorrectly?", AbstractCommonRestriction.getArgumentTitle(state, arguments), value);
    }

    @Override
    public <T> void validate(ParseState<T> state) {
        String value;
        for (Pair<OptionMetadata, Object> parsedOption : state.getParsedOptions()) {
            if (!(parsedOption.getValue() instanceof String) || this.isValid(value = (String)parsedOption.getValue())) continue;
            this.violated(state, parsedOption.getKey(), value);
        }
        for (Object parsedArg : state.getParsedArguments()) {
            if (!(parsedArg instanceof String) || this.isValid(value = (String)parsedArg)) continue;
            this.violated(state, state.getCommand().getArguments(), value);
        }
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{String.format("This options value must not look like it could be an option.  Any option-like value will be rejected.", new Object[0])};
    }
}

