/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.resources;

import com.github.rvesse.airline.parser.resources.ResourceLocator;
import java.io.IOException;
import java.io.InputStream;

public class ModulePathLocator
implements ResourceLocator {
    @Override
    public InputStream open(String searchLocation, String filename) throws IOException {
        InputStream locStream;
        if (searchLocation == null) {
            return null;
        }
        if (searchLocation.startsWith("classpath:")) {
            searchLocation = searchLocation.substring("classpath:".length());
        }
        if (searchLocation.startsWith("/")) {
            searchLocation = searchLocation.length() > 1 ? searchLocation.substring(1) : "";
        }
        StringBuilder resourceName = new StringBuilder();
        resourceName.append(searchLocation);
        if (!searchLocation.endsWith("/") && searchLocation.length() > 0) {
            resourceName.append("/");
        }
        resourceName.append(filename);
        InputStream resourceStream = ClassLoader.getSystemResourceAsStream(resourceName.toString());
        if (resourceStream != null) {
            return resourceStream;
        }
        if (!searchLocation.endsWith("/") && (locStream = ClassLoader.getSystemResourceAsStream(searchLocation)) != null) {
            return locStream;
        }
        return null;
    }
}

