/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionUnexpectedException;
import com.github.rvesse.airline.parser.options.ListValueOptionParser;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.lang3.StringUtils;

public class MaybeListValueOptionParser<T>
extends ListValueOptionParser<T> {
    public MaybeListValueOptionParser() {
    }

    public MaybeListValueOptionParser(char separator) {
        super(separator);
    }

    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        String list;
        String name = tokens.peek();
        boolean noSep = false;
        OptionMetadata option = this.findOption(state, allowedOptions, name);
        if (option == null) {
            if (this.hasShortNamePrefix(name) && name.length() > 2) {
                String shortName = name.substring(0, 2);
                option = this.findOption(state, allowedOptions, shortName);
                boolean bl = noSep = option != null;
            }
            if (!noSep) {
                return null;
            }
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        String string = list = noSep ? name.substring(2) : null;
        if (option.getArity() == 0) {
            String rawBooleanValue = state.getParserConfiguration().allowsFlagNegation() && StringUtils.startsWith(name, state.getParserConfiguration().getFlagNegationPrefix()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state = state.withOptionValue(option, rawBooleanValue).popContext();
        } else {
            if (list == null) {
                if (!tokens.hasNext()) {
                    return state;
                }
                if (this.isSeparatorOrOption(state, allowedOptions, state.getParserConfiguration().getArgumentsSeparator(), false, tokens.peek())) {
                    this.noValueForOption(state, option);
                    return state;
                }
                list = tokens.next();
            }
            List<String> listValues = this.getValues(list);
            boolean greedySearch = this.canGreedySearch(state);
            while (tokens.hasNext() && (greedySearch || listValues.size() % option.getArity() != 0)) {
                String nextValue = tokens.peek();
                OptionMetadata nextOption = this.findOption(state, allowedOptions, nextValue);
                if (nextOption == null && this.hasShortNamePrefix(nextValue) && nextValue.length() > 2) {
                    String shortName = nextValue.substring(0, 2);
                    nextOption = this.findOption(state, allowedOptions, shortName);
                    boolean bl = noSep = nextOption != null;
                }
                if (nextOption != null || StringUtils.equals(nextValue, state.getParserConfiguration().getArgumentsSeparator())) break;
                nextValue = tokens.next();
                listValues.addAll(this.getValues(nextValue));
            }
            if (listValues.size() < option.getArity()) {
                state.getParserConfiguration().getErrorHandler().handleError(new ParseOptionMissingValueException("Too few option values received for option %s in list value '%s' (%d values expected but only found %d)", option.getOptions().iterator().next(), option.getOptions().iterator().next(), list, option.getArity(), listValues.size()));
                return state;
            }
            if (listValues.size() > option.getArity() && listValues.size() % option.getArity() != 0) {
                state.getParserConfiguration().getErrorHandler().handleError(new ParseOptionUnexpectedException("Too many option values received for option %s in list value '%s' (%d values expected but found %d)", option.getOptions().iterator().next(), list, option.getArity(), listValues.size()));
                return state;
            }
            for (String value : listValues) {
                state = state.withOptionValue(option, value);
            }
            state = state.popContext();
        }
        return state;
    }

    protected boolean canGreedySearch(ParseState<T> state) {
        return state.getCommand().getArguments() == null && state.getCommand().getDefaultOption() == null;
    }
}

