/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.aliases;

import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.parser.aliases.AliasArgumentsParser;
import com.github.rvesse.airline.parser.resources.FileLocator;
import com.github.rvesse.airline.parser.resources.HomeDirectoryLocator;
import com.github.rvesse.airline.parser.resources.ResourceLocator;
import com.github.rvesse.airline.parser.resources.WorkingDirectoryLocator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class UserAliasesSource<C> {
    public static final ResourceLocator[] DEFAULT_LOCATORS = new ResourceLocator[]{new WorkingDirectoryLocator(), new HomeDirectoryLocator(), new FileLocator()};
    private final List<ResourceLocator> locators;
    private final List<String> searchLocations;
    private final String filename;
    private final String prefix;

    public UserAliasesSource(String filename, String prefix, String ... searchLocations) {
        this(filename, prefix, null, Arrays.asList(searchLocations));
    }

    public UserAliasesSource(String filename, String prefix, List<ResourceLocator> locators, List<String> searchLocations) {
        this.filename = filename;
        this.prefix = prefix;
        this.searchLocations = Collections.unmodifiableList(searchLocations);
        List<ResourceLocator> list = this.locators = locators == null ? Arrays.asList(DEFAULT_LOCATORS) : Collections.unmodifiableList(locators);
        if (StringUtils.isBlank(this.filename)) {
            throw new IllegalArgumentException("Filename cannot be null/empty/blank");
        }
        if (this.searchLocations.size() == 0) {
            throw new IllegalArgumentException("At least one search location must be specified");
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String> getSearchLocations() {
        return this.searchLocations;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<ResourceLocator> getLocators() {
        return this.locators;
    }

    public List<AliasMetadata> load() throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        HashSet<String> loaded = new HashSet<String>();
        block10: for (int i = this.searchLocations.size() - 1; i >= 0; --i) {
            String loc = this.searchLocations.get(i);
            if (StringUtils.isBlank(loc) || loaded.contains(loc)) continue;
            for (ResourceLocator locator : this.locators) {
                try {
                    InputStream input;
                    block19: {
                        input = locator.open(loc, this.filename);
                        try {
                            if (input != null) break block19;
                            if (input == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        input.close();
                        continue;
                    }
                    properties.load(input);
                    if (input == null) continue block10;
                    input.close();
                    continue block10;
                }
                finally {
                    loaded.add(loc);
                }
            }
        }
        if (StringUtils.isNotBlank(this.prefix)) {
            ArrayList<Object> keysToRemove = new ArrayList<Object>();
            for (Object key : properties.keySet()) {
                if (key.toString().startsWith(this.prefix)) continue;
                keysToRemove.add(key);
            }
            for (Object key : keysToRemove) {
                properties.remove(key);
            }
        }
        ArrayList<AliasMetadata> aliases = new ArrayList<AliasMetadata>();
        for (Object key : properties.keySet()) {
            String value;
            String name = key.toString();
            if (!StringUtils.isBlank(this.prefix)) {
                name = name.substring(this.prefix.length());
            }
            if (StringUtils.isEmpty(value = properties.getProperty(key.toString()))) {
                aliases.add(new AliasMetadata(name, Collections.emptyList()));
                continue;
            }
            List<String> args = AliasArgumentsParser.parse(value);
            aliases.add(new AliasMetadata(name, args));
        }
        return aliases;
    }
}

