/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.Accessor;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.types.DefaultTypeConverterProvider;
import com.github.rvesse.airline.types.TypeConverterProvider;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.restrictions.IsRequiredOptionFinder;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;

public class OptionMetadata {
    private final OptionType optionType;
    private final Set<String> options;
    private final List<String> titles;
    private final String description;
    private final int arity;
    private final boolean hidden;
    private final boolean overrides;
    private final boolean sealed;
    private final List<OptionRestriction> restrictions;
    private final TypeConverterProvider provider;
    private Set<Accessor> accessors;

    public OptionMetadata(OptionType optionType, Iterable<String> options, Iterable<String> titles, String description, int arity, boolean hidden, boolean overrides, boolean sealed, Iterable<OptionRestriction> restrictions, TypeConverterProvider typeConverterProvider, Iterable<Field> path) {
        if (optionType == null) {
            throw new NullPointerException("optionType cannot be null");
        }
        if (options == null) {
            throw new NullPointerException("options cannot be null");
        }
        if (!options.iterator().hasNext()) {
            throw new NullPointerException("options cannot be empty");
        }
        if (titles == null) {
            throw new NullPointerException("title cannot be null");
        }
        if (!titles.iterator().hasNext()) {
            throw new NullPointerException("titles cannot be empty");
        }
        this.optionType = optionType;
        this.options = AirlineUtils.unmodifiableSetCopy(options);
        this.titles = AirlineUtils.unmodifiableListCopy(titles);
        this.description = description;
        this.arity = arity;
        this.hidden = hidden;
        this.overrides = overrides;
        this.sealed = sealed;
        this.restrictions = restrictions != null ? AirlineUtils.unmodifiableListCopy(restrictions) : Collections.emptyList();
        TypeConverterProvider typeConverterProvider2 = this.provider = typeConverterProvider != null ? typeConverterProvider : new DefaultTypeConverterProvider();
        if (path != null) {
            this.accessors = SetUtils.unmodifiableSet(Collections.singleton(new Accessor(path)));
        }
    }

    public OptionMetadata(Iterable<OptionMetadata> options) {
        if (options == null) {
            throw new NullPointerException("options cannot be null");
        }
        if (!options.iterator().hasNext()) {
            throw new IllegalArgumentException("options cannot be empty");
        }
        OptionMetadata option = options.iterator().next();
        this.optionType = option.optionType;
        this.options = option.options;
        this.titles = option.titles;
        this.description = option.description;
        this.arity = option.arity;
        this.hidden = option.hidden;
        this.overrides = option.overrides;
        this.sealed = option.sealed;
        this.restrictions = option.restrictions;
        this.provider = option.provider;
        LinkedHashSet<Accessor> accessors = new LinkedHashSet<Accessor>();
        for (OptionMetadata other : options) {
            if (!option.equals(other)) {
                throw new IllegalArgumentException(String.format("Duplicate options definitions: %s, %s", option, other));
            }
            accessors.addAll(other.getAccessors());
        }
        this.accessors = SetUtils.unmodifiableSet(accessors);
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    @Deprecated
    public String getTitle() {
        return AirlineUtils.first(this.titles);
    }

    public String getTitle(int index) {
        if (this.arity == 0) {
            return this.titles.get(0);
        }
        if (index < 0 || index >= this.arity) {
            throw new IllegalArgumentException(String.format("Title index must be between 0 and %d (got %d)", this.arity, index));
        }
        return index < this.titles.size() ? this.titles.get(index) : this.titles.get(this.titles.size() - 1);
    }

    public String getDescription() {
        return this.description;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isRequired() {
        return CollectionUtils.exists(this.restrictions, new IsRequiredOptionFinder());
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isOverride() {
        return this.overrides;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean isMultiValued() {
        return this.accessors.iterator().next().isMultiValued();
    }

    public Class<?> getJavaType() {
        return this.accessors.iterator().next().getJavaType();
    }

    public Set<Accessor> getAccessors() {
        if (this.accessors == null) {
            throw new NullPointerException("No accessors defined for option");
        }
        return this.accessors;
    }

    public List<OptionRestriction> getRestrictions() {
        return this.restrictions;
    }

    public TypeConverterProvider getTypeConverterProvider() {
        return this.provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionMetadata that = (OptionMetadata)o;
        if (this.arity != that.arity) {
            return false;
        }
        if (this.hidden != that.hidden) {
            return false;
        }
        if (this.overrides != that.overrides) {
            return false;
        }
        if (this.sealed != that.sealed) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.optionType != that.optionType) {
            return false;
        }
        if (!this.options.equals(that.options)) {
            return false;
        }
        return this.titles.equals(that.titles);
    }

    public int hashCode() {
        int result = this.optionType.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.titles.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.arity;
        result = 31 * result + (this.hidden ? 1 : 0);
        result = 31 * result + (this.overrides ? 1 : 0);
        result = 31 * result + (this.sealed ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OptionMetadata");
        sb.append("{optionType=").append((Object)this.optionType);
        sb.append(", options=").append(this.options);
        sb.append(", title=").append(this.titles);
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", arity=").append(this.arity);
        sb.append(", hidden=").append(this.hidden);
        sb.append(", override=").append(this.overrides);
        sb.append(", sealed=").append(this.sealed);
        sb.append(", accessors=").append(this.accessors);
        sb.append('}');
        return sb.toString();
    }

    public static OptionMetadata override(Set<String> names, OptionMetadata parent, OptionMetadata child) {
        boolean isDuplicate;
        Class<?> childType;
        if (parent.optionType != child.optionType) {
            throw new IllegalArgumentException(String.format("Cannot change optionType when overriding option %s", names));
        }
        if (parent.arity != child.arity) {
            throw new IllegalArgumentException(String.format("Cannot change arity when overriding option %s", names));
        }
        if (!parent.options.equals(child.options)) {
            throw new IllegalArgumentException(String.format("Cannot change option names when overriding option %s", names));
        }
        Class<?> parentType = parent.getJavaType();
        if (!parentType.equals(childType = child.getJavaType()) && !parentType.isAssignableFrom(childType)) {
            if (childType.isAssignableFrom(parentType)) {
                throw new IllegalArgumentException(String.format("Cannot change the Java type from %s to %s when overriding option %s as this is a widening type change - only narrowing type changes are permitted", parentType, childType, names));
            }
            throw new IllegalArgumentException(String.format("Cannot change the Java type from %s to %s when overriding option %s - only narrowing type changes where a valid cast exists are permitted", parentType, childType, names));
        }
        boolean bl = isDuplicate = parent == child || parent.equals(child);
        if (parent.sealed && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Cannot override option %s as parent option declares it to be sealed", names));
        }
        if (!child.overrides && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Cannot override option %s unless child option sets overrides to true", names));
        }
        OptionMetadata merged = new OptionMetadata(child.optionType, child.options, child.titles != null ? child.titles : parent.titles, child.description != null ? child.description : parent.description, child.arity, child.hidden, child.overrides, child.sealed, child.restrictions.size() > 0 ? child.restrictions : parent.restrictions, child.provider, null);
        LinkedHashSet<Accessor> accessors = new LinkedHashSet<Accessor>(child.accessors);
        accessors.addAll(parent.accessors);
        merged.accessors = AirlineUtils.unmodifiableSetCopy(accessors);
        return merged;
    }
}

