/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliUsageHelper;
import com.github.rvesse.airline.help.common.AbstractPrintedGlobalUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.IterableUtils;

public class CliGlobalUsageSummaryGenerator<T>
extends AbstractPrintedGlobalUsageGenerator<T> {
    private final CliUsageHelper helper;

    public CliGlobalUsageSummaryGenerator() {
        this(79, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageSummaryGenerator(boolean includeHidden) {
        this(79, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize, boolean includeHidden) {
        this(columnSize, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize, Comparator<? super HelpHint> hintComparator, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(columnSize, hintComparator, optionComparator, commandComparator, commandGroupComparator, includeHidden);
        this.helper = this.createHelper(optionComparator, includeHidden);
    }

    protected CliUsageHelper createHelper(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        return new CliUsageHelper(optionComparator, includeHidden);
    }

    @Override
    public void usage(GlobalMetadata<T> global, UsagePrinter out) throws IOException {
        this.outputSynopsis(out, global);
        this.outputCommandList(out, global);
        this.outputFooter(out, global);
        ArrayList<HelpSection> preSections = new ArrayList<HelpSection>();
        ArrayList<HelpSection> postSections = new ArrayList<HelpSection>();
        this.findHelpSections(global, preSections, postSections);
        if (preSections.size() > 0 || postSections.size() > 0) {
            out.newline();
        }
        for (HelpSection section : preSections) {
            this.helper.outputHelpSection(out, section);
        }
        for (HelpSection section : postSections) {
            this.helper.outputHelpSection(out, section);
        }
    }

    protected void outputFooter(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        boolean hasHelpCommand;
        boolean bl = hasHelpCommand = IterableUtils.find(global.getDefaultGroupCommands(), new CommandFinder("help")) != null;
        if (hasHelpCommand) {
            out.newline();
            out.append("See").append("'" + global.getName()).append("help <command>' for more information on a specific command.").newline();
        }
    }

    protected void outputCommandList(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        for (CommandMetadata commandMetadata : this.sortCommands(global.getDefaultGroupCommands())) {
            if (commandMetadata.isHidden() && !this.includeHidden()) continue;
            commands.put(commandMetadata.getName(), commandMetadata.getDescription());
        }
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            if (group.isHidden() && !this.includeHidden()) continue;
            commands.put(group.getName(), group.getDescription());
        }
        out.append("Commands are:").newline();
        ArrayList commandDetails = new ArrayList();
        for (Map.Entry details : commands.entrySet()) {
            ArrayList<String> data = new ArrayList<String>();
            data.add((String)details.getKey());
            data.add((String)details.getValue());
            commandDetails.add(data);
        }
        out.newIndentedPrinter(4).appendTable(commandDetails, 0);
    }

    protected void outputSynopsis(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        ArrayList<String> commandArguments = new ArrayList<String>();
        for (OptionMetadata option : this.sortOptions(global.getOptions())) {
            if (option.isHidden() && !this.includeHidden()) continue;
            commandArguments.add(this.toUsage(option));
        }
        out.newPrinterWithHangingIndent(8).append("usage:").append(global.getName()).appendWords(commandArguments).append("<command> [ <args> ]").newline().newline();
    }
}

