/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.builder.AbstractChildBuilder;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AliasBuilder<C>
extends AbstractChildBuilder<AliasMetadata, ParserMetadata<C>, ParserBuilder<C>> {
    private String name;
    private final List<String> arguments = new ArrayList<String>();

    public AliasBuilder(ParserBuilder<C> parserBuilder) {
        super(parserBuilder);
    }

    public AliasBuilder(ParserBuilder<C> parserBuilder, String name) {
        this(parserBuilder);
        this.withName(name);
    }

    public AliasBuilder<C> withName(String name) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("Alias name cannot be null/empty/whitespace");
        }
        this.name = name;
        return this;
    }

    public AliasBuilder<C> withArgument(String arg) {
        if (StringUtils.isEmpty(arg)) {
            throw new IllegalArgumentException("Alias argument cannot be null");
        }
        this.arguments.add(arg);
        return this;
    }

    public AliasBuilder<C> withArguments(String ... args) {
        for (String arg : args) {
            if (arg == null) {
                throw new NullPointerException("Alias argument cannot be null");
            }
            this.arguments.add(arg);
        }
        return this;
    }

    @Override
    public AliasMetadata build() {
        if (StringUtils.isBlank(this.name)) {
            throw new IllegalArgumentException("Alias name cannot be null/empty/whitespace");
        }
        return new AliasMetadata(this.name, this.arguments);
    }
}

